using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using Borland.Studio.ToolsAPI;
using BeWise.SharpBuilderTools.Utils;
using BeWise.SharpBuilderTools.Helpers;

namespace BeWise.SharpBuilderTools.Gui
{
	public class FrmViewFiles : System.Windows.Forms.Form
	{
		/**************************************************************/
		/*                    Constructor/ Destructor
		/**************************************************************/

		public FrmViewFiles()
		{
			InitializeComponent();
		}

		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		/**************************************************************/
		/*                         Private
		/**************************************************************/

		private ViewAllFilesHelper fViewAllFilesHelper;
		private ViewOpenFilesHelper fViewOpenFilesHelper;
		private ViewAssembliesHelper fViewAssembliesHelper;
		private ViewFormsHelper fViewFormsHelper;
		private ViewSourceFilesHelper fViewSourceFilesHelper;

		private System.Windows.Forms.Label lblAll;
		private System.Windows.Forms.TabPage tpAll;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.TabPage tpOpenFiles;
		private System.Windows.Forms.TabPage tpAssemblies;
		private System.Windows.Forms.ImageList imageList;
		private System.Windows.Forms.ComboBox cbProjects;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.Button btCancel;
		private System.Windows.Forms.Button btOk;
		private System.Windows.Forms.TabControl TabControl;
		private System.Windows.Forms.TextBox txtAllFiles;
		private System.Windows.Forms.ListView lvAllFiles;
		private System.Windows.Forms.TabPage tpSourceFiles;
		private System.Windows.Forms.Label lblAssemblies;
		private System.Windows.Forms.TextBox txtAssemblies;
		private System.Windows.Forms.ListView lvAssemblies;
		private System.Windows.Forms.ListView lvSourceFiles;
		private System.Windows.Forms.Label lblSourceFiles;
		private System.Windows.Forms.TextBox txtSourceFiles;
		private System.Windows.Forms.ColumnHeader colAllType;
		private System.Windows.Forms.ColumnHeader colAllFileName;
		private System.Windows.Forms.ListView lvOpenFiles;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.TextBox txtOpenFiles;
		private System.Windows.Forms.Label lblOpenFiles;
		private System.Windows.Forms.TabPage tpForms;
		private System.Windows.Forms.TextBox txtForms;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.ListView lvForms;
		private System.Windows.Forms.ColumnHeader colSourceFileName;
		private System.Windows.Forms.ColumnHeader colAssembliesFileName;
		private System.Windows.Forms.ColumnHeader colForms;

		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.btCancel = new System.Windows.Forms.Button();
			this.btOk = new System.Windows.Forms.Button();
			this.TabControl = new System.Windows.Forms.TabControl();
			this.tpAll = new System.Windows.Forms.TabPage();
			this.txtAllFiles = new System.Windows.Forms.TextBox();
			this.lvAllFiles = new System.Windows.Forms.ListView();
			this.colAllType = new System.Windows.Forms.ColumnHeader();
			this.colAllFileName = new System.Windows.Forms.ColumnHeader();
			this.imageList = new System.Windows.Forms.ImageList(this.components);
			this.lblAll = new System.Windows.Forms.Label();
			this.tpSourceFiles = new System.Windows.Forms.TabPage();
			this.txtSourceFiles = new System.Windows.Forms.TextBox();
			this.lblSourceFiles = new System.Windows.Forms.Label();
			this.lvSourceFiles = new System.Windows.Forms.ListView();
			this.colSourceFileName = new System.Windows.Forms.ColumnHeader();
			this.tpOpenFiles = new System.Windows.Forms.TabPage();
			this.txtOpenFiles = new System.Windows.Forms.TextBox();
			this.lblOpenFiles = new System.Windows.Forms.Label();
			this.lvOpenFiles = new System.Windows.Forms.ListView();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.tpAssemblies = new System.Windows.Forms.TabPage();
			this.lvAssemblies = new System.Windows.Forms.ListView();
			this.colAssembliesFileName = new System.Windows.Forms.ColumnHeader();
			this.txtAssemblies = new System.Windows.Forms.TextBox();
			this.lblAssemblies = new System.Windows.Forms.Label();
			this.tpForms = new System.Windows.Forms.TabPage();
			this.txtForms = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.lvForms = new System.Windows.Forms.ListView();
			this.colForms = new System.Windows.Forms.ColumnHeader();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.cbProjects = new System.Windows.Forms.ComboBox();
			this.TabControl.SuspendLayout();
			this.tpAll.SuspendLayout();
			this.tpSourceFiles.SuspendLayout();
			this.tpOpenFiles.SuspendLayout();
			this.tpAssemblies.SuspendLayout();
			this.tpForms.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// btCancel
			// 
			this.btCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btCancel.Location = new System.Drawing.Point(536, 464);
			this.btCancel.Name = "btCancel";
			this.btCancel.TabIndex = 2;
			this.btCancel.Text = "Cancel";
			// 
			// btOk
			// 
			this.btOk.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btOk.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btOk.Location = new System.Drawing.Point(456, 464);
			this.btOk.Name = "btOk";
			this.btOk.TabIndex = 1;
			this.btOk.Text = "Ok";
			this.btOk.Click += new System.EventHandler(this.btOk_Click);
			// 
			// TabControl
			// 
			this.TabControl.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.TabControl.Controls.Add(this.tpAll);
			this.TabControl.Controls.Add(this.tpOpenFiles);
			this.TabControl.Controls.Add(this.tpAssemblies);
			this.TabControl.Controls.Add(this.tpSourceFiles);
			this.TabControl.Controls.Add(this.tpForms);
			this.TabControl.Location = new System.Drawing.Point(8, 64);
			this.TabControl.Name = "TabControl";
			this.TabControl.SelectedIndex = 0;
			this.TabControl.Size = new System.Drawing.Size(608, 392);
			this.TabControl.TabIndex = 0;
			this.TabControl.TabStop = false;
			this.TabControl.SelectedIndexChanged += new System.EventHandler(this.TabControl_SelectedIndexChanged);
			// 
			// tpAll
			// 
			this.tpAll.Controls.Add(this.txtAllFiles);
			this.tpAll.Controls.Add(this.lvAllFiles);
			this.tpAll.Controls.Add(this.lblAll);
			this.tpAll.Location = new System.Drawing.Point(4, 22);
			this.tpAll.Name = "tpAll";
			this.tpAll.Size = new System.Drawing.Size(600, 366);
			this.tpAll.TabIndex = 0;
			this.tpAll.Text = "All";
			// 
			// txtAllFiles
			// 
			this.txtAllFiles.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAllFiles.Location = new System.Drawing.Point(80, 8);
			this.txtAllFiles.Name = "txtAllFiles";
			this.txtAllFiles.Size = new System.Drawing.Size(512, 20);
			this.txtAllFiles.TabIndex = 0;
			this.txtAllFiles.Text = "";
			this.txtAllFiles.TextChanged += new System.EventHandler(this.txtItem_TextChanged);
			this.txtAllFiles.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtItem_KeyUp);
			// 
			// lvAllFiles
			// 
			this.lvAllFiles.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.lvAllFiles.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
						this.colAllType,
						this.colAllFileName});
			this.lvAllFiles.FullRowSelect = true;
			this.lvAllFiles.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.lvAllFiles.HideSelection = false;
			this.lvAllFiles.Location = new System.Drawing.Point(0, 40);
			this.lvAllFiles.MultiSelect = false;
			this.lvAllFiles.Name = "lvAllFiles";
			this.lvAllFiles.Size = new System.Drawing.Size(584, 320);
			this.lvAllFiles.SmallImageList = this.imageList;
			this.lvAllFiles.TabIndex = 5;
			this.lvAllFiles.View = System.Windows.Forms.View.Details;
			this.lvAllFiles.DoubleClick += new System.EventHandler(this.ListView_DoubleClick);
			// 
			// colAllType
			// 
			this.colAllType.Text = "Type";
			// 
			// colAllFileName
			// 
			this.colAllFileName.Text = "File name";
			this.colAllFileName.Width = 505;
			// 
			// imageList
			// 
			this.imageList.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// lblAll
			// 
			this.lblAll.Location = new System.Drawing.Point(8, 11);
			this.lblAll.Name = "lblAll";
			this.lblAll.Size = new System.Drawing.Size(100, 24);
			this.lblAll.TabIndex = 8;
			this.lblAll.Text = "File name";
			// 
			// tpSourceFiles
			// 
			this.tpSourceFiles.Controls.Add(this.txtSourceFiles);
			this.tpSourceFiles.Controls.Add(this.lblSourceFiles);
			this.tpSourceFiles.Controls.Add(this.lvSourceFiles);
			this.tpSourceFiles.Location = new System.Drawing.Point(4, 22);
			this.tpSourceFiles.Name = "tpSourceFiles";
			this.tpSourceFiles.Size = new System.Drawing.Size(600, 366);
			this.tpSourceFiles.TabIndex = 3;
			this.tpSourceFiles.Text = "Source Files";
			// 
			// txtSourceFiles
			// 
			this.txtSourceFiles.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSourceFiles.Location = new System.Drawing.Point(80, 8);
			this.txtSourceFiles.Name = "txtSourceFiles";
			this.txtSourceFiles.Size = new System.Drawing.Size(512, 20);
			this.txtSourceFiles.TabIndex = 0;
			this.txtSourceFiles.Text = "";
			this.txtSourceFiles.TextChanged += new System.EventHandler(this.txtItem_TextChanged);
			this.txtSourceFiles.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtItem_KeyUp);
			// 
			// lblSourceFiles
			// 
			this.lblSourceFiles.Location = new System.Drawing.Point(8, 11);
			this.lblSourceFiles.Name = "lblSourceFiles";
			this.lblSourceFiles.Size = new System.Drawing.Size(100, 22);
			this.lblSourceFiles.TabIndex = 9;
			this.lblSourceFiles.Text = "File name";
			// 
			// lvSourceFiles
			// 
			this.lvSourceFiles.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.lvSourceFiles.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
						this.colSourceFileName});
			this.lvSourceFiles.FullRowSelect = true;
			this.lvSourceFiles.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.lvSourceFiles.HideSelection = false;
			this.lvSourceFiles.Location = new System.Drawing.Point(8, 40);
			this.lvSourceFiles.MultiSelect = false;
			this.lvSourceFiles.Name = "lvSourceFiles";
			this.lvSourceFiles.Size = new System.Drawing.Size(584, 320);
			this.lvSourceFiles.TabIndex = 6;
			this.lvSourceFiles.View = System.Windows.Forms.View.Details;
			this.lvSourceFiles.DoubleClick += new System.EventHandler(this.ListView_DoubleClick);
			// 
			// colSourceFileName
			// 
			this.colSourceFileName.Text = "File name";
			this.colSourceFileName.Width = 565;
			// 
			// tpOpenFiles
			// 
			this.tpOpenFiles.Controls.Add(this.txtOpenFiles);
			this.tpOpenFiles.Controls.Add(this.lblOpenFiles);
			this.tpOpenFiles.Controls.Add(this.lvOpenFiles);
			this.tpOpenFiles.Location = new System.Drawing.Point(4, 22);
			this.tpOpenFiles.Name = "tpOpenFiles";
			this.tpOpenFiles.Size = new System.Drawing.Size(600, 366);
			this.tpOpenFiles.TabIndex = 1;
			this.tpOpenFiles.Text = "Open Files";
			// 
			// txtOpenFiles
			// 
			this.txtOpenFiles.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOpenFiles.Location = new System.Drawing.Point(80, 8);
			this.txtOpenFiles.Name = "txtOpenFiles";
			this.txtOpenFiles.Size = new System.Drawing.Size(512, 20);
			this.txtOpenFiles.TabIndex = 2;
			this.txtOpenFiles.Text = "";
			this.txtOpenFiles.TextChanged += new System.EventHandler(this.txtItem_TextChanged);
			this.txtOpenFiles.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtItem_KeyUp);
			// 
			// lblOpenFiles
			// 
			this.lblOpenFiles.Location = new System.Drawing.Point(8, 11);
			this.lblOpenFiles.Name = "lblOpenFiles";
			this.lblOpenFiles.TabIndex = 10;
			this.lblOpenFiles.Text = "File name";
			// 
			// lvOpenFiles
			// 
			this.lvOpenFiles.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.lvOpenFiles.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
						this.columnHeader3,
						this.columnHeader4});
			this.lvOpenFiles.FullRowSelect = true;
			this.lvOpenFiles.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.lvOpenFiles.HideSelection = false;
			this.lvOpenFiles.Location = new System.Drawing.Point(0, 40);
			this.lvOpenFiles.MultiSelect = false;
			this.lvOpenFiles.Name = "lvOpenFiles";
			this.lvOpenFiles.Size = new System.Drawing.Size(584, 320);
			this.lvOpenFiles.TabIndex = 7;
			this.lvOpenFiles.View = System.Windows.Forms.View.Details;
			this.lvOpenFiles.DoubleClick += new System.EventHandler(this.ListView_DoubleClick);
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Type";
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "File name";
			this.columnHeader4.Width = 505;
			// 
			// tpAssemblies
			// 
			this.tpAssemblies.Controls.Add(this.lvAssemblies);
			this.tpAssemblies.Controls.Add(this.txtAssemblies);
			this.tpAssemblies.Controls.Add(this.lblAssemblies);
			this.tpAssemblies.Location = new System.Drawing.Point(4, 22);
			this.tpAssemblies.Name = "tpAssemblies";
			this.tpAssemblies.Size = new System.Drawing.Size(600, 366);
			this.tpAssemblies.TabIndex = 2;
			this.tpAssemblies.Text = "Assemblies";
			// 
			// lvAssemblies
			// 
			this.lvAssemblies.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.lvAssemblies.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
						this.colAssembliesFileName});
			this.lvAssemblies.FullRowSelect = true;
			this.lvAssemblies.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.lvAssemblies.HideSelection = false;
			this.lvAssemblies.Location = new System.Drawing.Point(8, 40);
			this.lvAssemblies.MultiSelect = false;
			this.lvAssemblies.Name = "lvAssemblies";
			this.lvAssemblies.Size = new System.Drawing.Size(584, 320);
			this.lvAssemblies.TabIndex = 11;
			this.lvAssemblies.View = System.Windows.Forms.View.Details;
			this.lvAssemblies.DoubleClick += new System.EventHandler(this.ListView_DoubleClick);
			// 
			// colAssembliesFileName
			// 
			this.colAssembliesFileName.Text = "File name";
			this.colAssembliesFileName.Width = 565;
			// 
			// txtAssemblies
			// 
			this.txtAssemblies.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAssemblies.Location = new System.Drawing.Point(80, 8);
			this.txtAssemblies.Name = "txtAssemblies";
			this.txtAssemblies.Size = new System.Drawing.Size(512, 20);
			this.txtAssemblies.TabIndex = 3;
			this.txtAssemblies.Text = "";
			this.txtAssemblies.TextChanged += new System.EventHandler(this.txtItem_TextChanged);
			this.txtAssemblies.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtItem_KeyUp);
			// 
			// lblAssemblies
			// 
			this.lblAssemblies.Location = new System.Drawing.Point(8, 11);
			this.lblAssemblies.Name = "lblAssemblies";
			this.lblAssemblies.TabIndex = 9;
			this.lblAssemblies.Text = "File name";
			// 
			// tpForms
			// 
			this.tpForms.Controls.Add(this.txtForms);
			this.tpForms.Controls.Add(this.label1);
			this.tpForms.Controls.Add(this.lvForms);
			this.tpForms.Location = new System.Drawing.Point(4, 22);
			this.tpForms.Name = "tpForms";
			this.tpForms.Size = new System.Drawing.Size(600, 366);
			this.tpForms.TabIndex = 4;
			this.tpForms.Text = "Forms";
			// 
			// txtForms
			// 
			this.txtForms.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.txtForms.Location = new System.Drawing.Point(80, 8);
			this.txtForms.Name = "txtForms";
			this.txtForms.Size = new System.Drawing.Size(512, 20);
			this.txtForms.TabIndex = 0;
			this.txtForms.Text = "";
			this.txtForms.TextChanged += new System.EventHandler(this.txtItem_TextChanged);
			this.txtForms.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtItem_KeyUp);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 11);
			this.label1.Name = "label1";
			this.label1.TabIndex = 12;
			this.label1.Text = "File name";
			// 
			// lvForms
			// 
			this.lvForms.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.lvForms.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
						this.colForms});
			this.lvForms.FullRowSelect = true;
			this.lvForms.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.lvForms.HideSelection = false;
			this.lvForms.Location = new System.Drawing.Point(8, 40);
			this.lvForms.MultiSelect = false;
			this.lvForms.Name = "lvForms";
			this.lvForms.Size = new System.Drawing.Size(584, 320);
			this.lvForms.TabIndex = 11;
			this.lvForms.View = System.Windows.Forms.View.Details;
			this.lvForms.DoubleClick += new System.EventHandler(this.ListView_DoubleClick);
			// 
			// colForms
			// 
			this.colForms.Text = "File name";
			this.colForms.Width = 565;
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.cbProjects);
			this.groupBox1.Location = new System.Drawing.Point(8, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(608, 48);
			this.groupBox1.TabIndex = 3;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Filters";
			// 
			// cbProjects
			// 
			this.cbProjects.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.cbProjects.Location = new System.Drawing.Point(16, 16);
			this.cbProjects.Name = "cbProjects";
			this.cbProjects.Size = new System.Drawing.Size(584, 21);
			this.cbProjects.TabIndex = 0;
			this.cbProjects.Text = "All Projects";
			this.cbProjects.SelectedIndexChanged += new System.EventHandler(this.cbProjects_SelectedIndexChanged);
			// 
			// FrmViewFiles
			// 
			this.AcceptButton = this.btOk;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btCancel;
			this.ClientSize = new System.Drawing.Size(624, 494);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.TabControl);
			this.Controls.Add(this.btOk);
			this.Controls.Add(this.btCancel);
			this.Name = "FrmViewFiles";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "View Files";
			this.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtItem_KeyUp);
			this.TabControl.ResumeLayout(false);
			this.tpAll.ResumeLayout(false);
			this.tpSourceFiles.ResumeLayout(false);
			this.tpOpenFiles.ResumeLayout(false);
			this.tpAssemblies.ResumeLayout(false);
			this.tpForms.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);
		}

		private void btOk_Click(object sender, System.EventArgs e) {
			if (GetCurrentListView().SelectedItems.Count > 0) {
				GetCurrentViewFileModeHelper().GoTo(GetCurrentListView().SelectedItems[0].Tag);
			}

			Close();
		}

		private void ListView_DoubleClick(object sender, System.EventArgs e) {
			btOk_Click(sender, e);
		}

		private void txtItem_TextChanged(object sender, System.EventArgs e) {
			LoadItemsInListView();
		}

		private void txtItem_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e) {
			ListViewItem _SourceItems = null;
			ListViewItem _DestItems = null;
            ListView _ListView = GetCurrentListView();

			if (e.KeyCode == Keys.Up) {
				if (_ListView.SelectedItems.Count > 0) {
					_SourceItems = _ListView.SelectedItems[0];

					if (_SourceItems.Index != 0) {
						_ListView.SelectedItems.Clear();
						_DestItems = _ListView.Items[_SourceItems.Index - 1];
						_DestItems.Selected = true;
					}
				}
			}
			else if (e.KeyCode == Keys.Down) {
				if (_ListView.SelectedItems.Count > 0) {
					_SourceItems = _ListView.SelectedItems[0];

					if (_SourceItems.Index < _ListView.Items.Count -1) {
						_ListView.SelectedItems.Clear();
						_DestItems = _ListView.Items[_SourceItems.Index + 1];
						_DestItems.Selected = true;
					}
				}
			}

			if (_DestItems != null) {
				_ListView.EnsureVisible(_DestItems.Index);
			}
		}

		private void TabControl_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			LoadItemsInListView();
			cbProjects.Enabled = (TabControl.SelectedTab != tpOpenFiles);
		}

		private void cbProjects_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			LoadItemsInListView();
		}

		/**************************************************************/
		/*                       Protected
		/**************************************************************/

		protected ViewFileModeHelper GetCurrentViewFileModeHelper() {
			if (TabControl.SelectedTab == tpAll) {
				if (fViewAllFilesHelper == null) {
					fViewAllFilesHelper = new ViewAllFilesHelper();
					fViewAllFilesHelper.Load();
				}

				return fViewAllFilesHelper;
			}
			else if (TabControl.SelectedTab == tpOpenFiles) {
				if (fViewOpenFilesHelper == null) {
					fViewOpenFilesHelper = new ViewOpenFilesHelper();
					fViewOpenFilesHelper.Load();
				}

				return fViewOpenFilesHelper;
			}
			else if (TabControl.SelectedTab == tpAssemblies) {
				if (fViewAssembliesHelper == null) {
					fViewAssembliesHelper = new ViewAssembliesHelper();
					fViewAssembliesHelper.Load();
				}

				return fViewAssembliesHelper;
			}
			else if (TabControl.SelectedTab == tpForms) {
				if (fViewFormsHelper == null) {
					fViewFormsHelper = new ViewFormsHelper();
					fViewFormsHelper.Load();
				}

				return fViewFormsHelper;
			}
			else {
				if (fViewSourceFilesHelper == null) {
					fViewSourceFilesHelper = new ViewSourceFilesHelper();
					fViewSourceFilesHelper.Load();
				}

				return fViewSourceFilesHelper;
			}
		}

		protected ListView GetCurrentListView() {
			if (TabControl.SelectedTab == tpAll) {
				return lvAllFiles;
			}
			else if (TabControl.SelectedTab == tpOpenFiles) {
				return lvOpenFiles;
			}
			else if (TabControl.SelectedTab == tpAssemblies) {
				return lvAssemblies;
			}
			else if (TabControl.SelectedTab == tpForms) {
				return lvForms;
			}
			else {
				return lvSourceFiles;
			}
		}

		protected TextBox GetCurrentTextBox() {
			if (TabControl.SelectedTab == tpAll) {
				return txtAllFiles;
			}
			else if (TabControl.SelectedTab == tpOpenFiles) {
				return txtOpenFiles;
			}
			else if (TabControl.SelectedTab == tpAssemblies) {
				return txtAssemblies;
			}
			else if (TabControl.SelectedTab == tpForms) {
				return txtForms;
			}
			else {
				return txtSourceFiles;
			}
		}

		protected void LoadItems() {
			ViewFileModeHelper _ViewFileModeHelper = GetCurrentViewFileModeHelper();

			_ViewFileModeHelper.Load();
		}

		protected void LoadProjectsInCombo() {
			cbProjects.Items.Clear();
			cbProjects.Items.Add("All Projects");
			cbProjects.Items.Add("Active Project");

			IOTAProjectGroup _ProjectGroup = OTAUtils.GetCurrentProjectGroup();

			if (_ProjectGroup != null) {
				for (int j= 0; j < _ProjectGroup.ProjectCount; j++) {
					IOTAProject _Project = _ProjectGroup[j];

					cbProjects.Items.Add(_Project.FileName);
				}
			}

			cbProjects.SelectedIndex = 0;
		}

		protected void LoadItemsInListView() {
			IComparer _Comparer  = GetCurrentViewFileModeHelper() as IComparer;

			Items.Sort(_Comparer);
			ListView _ListView = GetCurrentListView();
			string _ProjectFilter = null;

			object _SelectedItem = null;
			try {
				_ListView.BeginUpdate();
				try {
					if (_ListView.SelectedItems.Count > 0) {
						_SelectedItem = _ListView.SelectedItems[0].Tag;
					}

					_ListView.Items.Clear();
                    					
					if (cbProjects.SelectedIndex == 0) {
						_ProjectFilter = Consts.VIEW_FILES_ALL_PROJECTS;
					}
					else if (cbProjects.SelectedIndex == 1) {
						_ProjectFilter = Consts.VIEW_FILES_ACTIVE_PROJECT;
					}
					else {
						_ProjectFilter = cbProjects.Text;
					}
                             
					for (int i = 0; i < Items.Count; i ++) {
						if (GetCurrentViewFileModeHelper().ItemIsVisible(GetCurrentTextBox().Text, _ProjectFilter, Items[i])) {
							ListViewItem _Item = GetCurrentViewFileModeHelper().CreateListViewItem(Items[i]);
							_ListView.Items.Add(_Item);
						}
					}
				}
				finally {
					_ListView.EndUpdate();
				}
			}
			finally {
				if (_ListView.Items.Count > 0) {
					_ListView.Items[0].Selected = true;

					for (int j = 0; j < _ListView.Items.Count; j++) {

						if (_ListView.Items[j].Tag == _SelectedItem) {
							_ListView.Items[j].Selected = true;
							break;
						}
					}
				}
			}
		}

		/**************************************************************/
		/*                   Protected Properties
		/**************************************************************/

		protected ArrayList Items {
			get {
				return GetCurrentViewFileModeHelper().Items;
			}
		}

		/**************************************************************/
		/*                         Public
		/**************************************************************/

		public void SetViewFileMode(ViewFileMode aViewFileMode) {
			if (aViewFileMode == ViewFileMode.AllFiles) {
				TabControl.SelectedTab = tpAll;
			}
			else if (aViewFileMode == ViewFileMode.OpenFiles) {
				TabControl.SelectedTab = tpOpenFiles;
			}
			else if (aViewFileMode == ViewFileMode.Assemblies) {
				TabControl.SelectedTab = tpAssemblies;
			}
			else if (aViewFileMode == ViewFileMode.Forms) {
				TabControl.SelectedTab = tpForms;
			}
			else {
				TabControl.SelectedTab = tpSourceFiles;
			}

			LoadItems();
			LoadItemsInListView();
 			LoadProjectsInCombo();
		}
	}
}
